# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import getpass

from django.core.management import base as management

from core import models


class Command(management.BaseCommand):
    help = 'Switch superuser status for Administrator.'
    
    def add_arguments(self, parser):
        parser.add_argument('--on', action='count', help='Switch superuser on')
        parser.add_argument('--off', action='count', help='Switch superuser off')
        parser.add_argument('username', help='Username', default=getpass.getuser())

    def get_options(self, **options):
        return options['on'], options['off'], options['username']

    def handle(self, *args, **options):
        on, off, username = self.get_options(**options)
        if off and on:
            raise management.CommandError('Switches --off and --on are mutually exclusive')
        elif not(off or on):
            raise management.CommandError('Specify --off or --on')
        switch = bool(on and not off)
        models.Administrator.objects.filter(username=options['username']).update(is_superuser=switch)
        self.stdout.write(self.style.NOTICE('%s.is_superuser = %s' % (username, switch)))
