# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import logging
import urllib
import urlparse

from django.utils import translation


logger = logging.getLogger(__name__)


class SetLanguageByYandexDomain(object):

    def process_request(self, request):
        host = request.get_host().split(':')[0]

        DOMAINS = {
            'ru': ['ru', 'ua', 'by', 'kz'],
            'en': ['com', 'com.tr'],
        }

        for domain_language, domain_list in DOMAINS.iteritems():
            if any(host.endswith(domain) for domain in domain_list):
                language = domain_language
                break
        else:
            language = 'en'
            logger.critical('Forgotten host domain.')

        translation.activate(language)
        request.LANGUAGE_CODE = translation.get_language()
