# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models, migrations
import django.utils.timezone
import django.core.validators


class Migration(migrations.Migration):

    dependencies = [
        ('auth', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Reporter',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('password', models.CharField(max_length=128, verbose_name='password')),
                ('last_login', models.DateTimeField(default=django.utils.timezone.now, verbose_name='last login')),
                ('username', models.CharField(unique=True, max_length=30)),
                ('email', models.EmailField(max_length=75, blank=True)),
                ('display_name', models.CharField(max_length=255, blank=True)),
                ('contact_name', models.CharField(max_length=255, blank=True)),
                ('contact_email', models.EmailField(max_length=75, blank=True)),
                ('fb_link', models.CharField(blank=True, max_length=255, validators=[django.core.validators.RegexValidator(b'^[A-Za-z\\d.]{5,}$')])),
                ('twitter_link', models.CharField(blank=True, max_length=255, validators=[django.core.validators.RegexValidator(b'^[A-Za-z\\d_]{1,15}$')])),
                ('hacker_one_link', models.CharField(blank=True, max_length=255, validators=[django.core.validators.RegexValidator(b'^[A-Za-z\\d_-]{1,25}$')])),
                ('bug_crowd_link', models.CharField(blank=True, max_length=255, validators=[django.core.validators.RegexValidator(b'^[A-Za-z\\d_-]*$')])),
                ('personal_website', models.URLField(blank=True)),
                ('address', models.TextField(blank=True)),
                ('company_name', models.CharField(max_length=255, blank=True)),
                ('about', models.TextField(blank=True)),
                ('show_on_hall', models.BooleanField(default=True)),
                ('points', models.IntegerField(default=0)),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='Administrator',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('password', models.CharField(max_length=128, verbose_name='password')),
                ('last_login', models.DateTimeField(default=django.utils.timezone.now, verbose_name='last login')),
                ('is_superuser', models.BooleanField(default=False, help_text='Designates that this user has all permissions without explicitly assigning them.', verbose_name='superuser status')),
                ('username', models.CharField(help_text='Required. 30 characters or fewer. Letters, digits and @/./+/-/_ only.', unique=True, max_length=30, verbose_name='username', validators=[django.core.validators.RegexValidator('^[\\w.@+-]+$', 'Enter a valid username.', 'invalid')])),
                ('first_name', models.CharField(max_length=30, verbose_name='first name', blank=True)),
                ('last_name', models.CharField(max_length=30, verbose_name='last name', blank=True)),
                ('email', models.EmailField(max_length=75, verbose_name='email address', blank=True)),
                ('is_staff', models.BooleanField(default=False, help_text='Designates whether the user can log into this admin site.', verbose_name='staff status')),
                ('is_active', models.BooleanField(default=True, help_text='Designates whether this user should be treated as active. Unselect this instead of deleting accounts.', verbose_name='active')),
                ('date_joined', models.DateTimeField(default=django.utils.timezone.now, verbose_name='date joined')),
                ('groups', models.ManyToManyField(related_query_name='user', related_name='user_set', to='auth.Group', blank=True, help_text='The groups this user belongs to. A user will get all permissions granted to each of his/her group.', verbose_name='groups')),
                ('user_permissions', models.ManyToManyField(related_query_name='user', related_name='user_set', to='auth.Permission', blank=True, help_text='Specific permissions for this user.', verbose_name='user permissions')),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='Badge',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=255)),
                ('name_en', models.CharField(max_length=255)),
                ('image_url', models.URLField()),
                ('is_automatic', models.BooleanField(default=False)),
                ('is_active', models.BooleanField(default=True)),
                ('trigger', models.IntegerField(default=None, null=True, blank=True, choices=[(0, b'None'), (1, b'full_house'), (2, b'three_xss'), (3, b'most_active_reporter'), (4, b'reporter_of_the_quarter')])),
                ('check_interval', models.IntegerField(default=2, null=True, blank=True, choices=[(0, 'badge.ci_day'), (1, 'badge.ci_month'), (2, 'badge.ci_quarter')])),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='Document',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('document_id', models.CharField(max_length=100)),
                ('created', models.DateTimeField(auto_now_add=True)),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='Item',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='List',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('month', models.SmallIntegerField()),
                ('year', models.SmallIntegerField()),
                ('is_published', models.BooleanField(default=False)),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='MailTemplate',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('code', models.CharField(default='', max_length=100)),
                ('subject', models.CharField(default='', max_length=255)),
                ('language', models.IntegerField(default=0, choices=[(0, 'language.russian'), (1, 'language.english')])),
                ('template', models.TextField(default='')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True)),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='PaymentInfo',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('account_holder', models.CharField(max_length=255, blank=True)),
                ('account_number', models.CharField(max_length=255, blank=True)),
                ('account_address', models.TextField(blank=True)),
                ('iban', models.CharField(max_length=34, blank=True)),
                ('bank_name', models.CharField(max_length=255, blank=True)),
                ('swift_code', models.CharField(max_length=50, blank=True)),
                ('ru_fio', models.CharField(max_length=255, blank=True)),
                ('ru_account_number', models.CharField(max_length=50, blank=True)),
                ('ru_bank_name', models.CharField(max_length=255, blank=True)),
                ('ru_bic_code', models.CharField(max_length=50, blank=True)),
                ('ru_correspond_number', models.CharField(max_length=50, blank=True)),
                ('is_russian_resident', models.BooleanField(default=False)),
                ('document_id', models.CharField(max_length=100)),
                ('is_actual', models.BooleanField(default=True)),
                ('reporter', models.OneToOneField(related_name=b'payment_info', to='core.Reporter')),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='Reward',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('user_login', models.CharField(max_length=30)),
                ('user_uid', models.BigIntegerField()),
                ('staff_uid', models.BigIntegerField()),
                ('staff_login', models.CharField(max_length=30)),
                ('ticket_code', models.CharField(max_length=128)),
                ('ticket_info', models.CharField(max_length=128)),
                ('ticket_created', models.DateTimeField()),
                ('payment_created', models.DateTimeField(auto_now_add=True)),
                ('department', models.IntegerField(default=1, choices=[(1, b'SEMS'), (2, b'DPMS'), (3, b'MPMS'), (4, b'PSMS'), (5, b'MOMS'), (6, b'INMS'), (7, b'YMMS'), (8, b'MSMS')])),
                ('payment_amount', models.DecimalField(default=0, max_digits=10, decimal_places=2)),
                ('payment_currency', models.IntegerField(default=1, choices=[(1, 'currency.rur'), (2, 'currency.usd')])),
                ('status', models.IntegerField(default=0, choices=[(0, 'reward.new'), (1, 'reward.payable'), (2, 'reward.bad_details'), (3, 'reward.payed'), (4, 'reward.discarded')])),
                ('points', models.IntegerField(default=0)),
                ('comment', models.TextField(blank=True)),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='StaticPage',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('page_type', models.CharField(default='index', max_length=100, choices=[('index', 'index'), ('faq', 'faq'), ('report', 'report'), ('hall_of_fame', 'hall_of_fame')])),
                ('name', models.CharField(default='', max_length=255)),
                ('status', models.IntegerField(default=0, choices=[(3, 'page.published'), (1, 'page.in_tanker'), (0, 'page.draft')])),
                ('text', models.TextField(default='')),
                ('formatted_text', models.TextField(default='')),
                ('language', models.IntegerField(default=0, choices=[(0, 'language.russian'), (1, 'language.english')])),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True)),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='UserBadge',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('date', models.DateTimeField(auto_now=True)),
                ('badge', models.ForeignKey(to='core.Badge')),
                ('user', models.ForeignKey(related_name=b'badges', to='core.Reporter')),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='Vulnerability',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=10)),
                ('points', models.IntegerField()),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.AlterUniqueTogether(
            name='staticpage',
            unique_together=set([('language', 'page_type')]),
        ),
        migrations.AddField(
            model_name='reward',
            name='vulnerability_type',
            field=models.ForeignKey(to='core.Vulnerability'),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name='item',
            name='list',
            field=models.ForeignKey(related_name=b'items', to='core.List'),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name='item',
            name='user',
            field=models.ForeignKey(to='core.Reporter'),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name='document',
            name='payment_information',
            field=models.ForeignKey(to='core.PaymentInfo'),
            preserve_default=True,
        ),
    ]
