# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
import core.models.user
import django.db.models.deletion
import django.core.validators


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0033_badge_is_exclusive'),
    ]

    operations = [
        migrations.AlterModelManagers(
            name='administrator',
            managers=[
                ('objects', core.models.user.AdministratorManager()),
            ],
        ),
        migrations.AlterField(
            model_name='administrator',
            name='email',
            field=models.EmailField(max_length=254, verbose_name='email address', blank=True),
        ),
        migrations.AlterField(
            model_name='administrator',
            name='groups',
            field=models.ManyToManyField(related_query_name='user', related_name='user_set', to='auth.Group', blank=True, help_text='The groups this user belongs to. A user will get all permissions granted to each of their groups.', verbose_name='groups'),
        ),
        migrations.AlterField(
            model_name='administrator',
            name='last_login',
            field=models.DateTimeField(null=True, verbose_name='last login', blank=True),
        ),
        migrations.AlterField(
            model_name='administrator',
            name='username',
            field=models.CharField(error_messages={'unique': 'A user with that username already exists.'}, max_length=30, validators=[django.core.validators.RegexValidator('^[\\w.@+-]+$', 'Enter a valid username. This value may contain only letters, numbers and @/./+/-/_ characters.', 'invalid')], help_text='Required. 30 characters or fewer. Letters, digits and @/./+/-/_ only.', unique=True, verbose_name='username'),
        ),
        migrations.AlterField(
            model_name='badge',
            name='check_interval',
            field=models.IntegerField(default=2, null=True, blank=True, choices=[(0, 'badge.ci_day'), (1, 'badge.ci_month'), (2, 'badge.ci_quarter')]),
        ),
        migrations.AlterField(
            model_name='mailtemplate',
            name='language',
            field=models.IntegerField(default=0, choices=[(0, 'language.russian'), (1, 'language.english')]),
        ),
        migrations.AlterField(
            model_name='reporter',
            name='contact_email',
            field=models.EmailField(max_length=254, blank=True),
        ),
        migrations.AlterField(
            model_name='reporter',
            name='email',
            field=models.EmailField(max_length=254, blank=True),
        ),
        migrations.AlterField(
            model_name='reporter',
            name='last_login',
            field=models.DateTimeField(null=True, verbose_name='last login', blank=True),
        ),
        migrations.AlterField(
            model_name='reward',
            name='department',
            field=models.IntegerField(default=1, choices=[(1, 'SEMS'), (2, 'DPMS'), (3, 'MPMS'), (4, 'PSMS'), (5, 'MOMS'), (6, 'INMS'), (7, 'YMMS'), (8, 'MSMS'), (9, 'VSMS'), (10, 'BMMS')]),
        ),
        migrations.AlterField(
            model_name='reward',
            name='payment_currency',
            field=models.IntegerField(default=1, choices=[(1, 'currency.rur'), (2, 'currency.usd')]),
        ),
        migrations.AlterField(
            model_name='reward',
            name='status',
            field=models.IntegerField(default=0, choices=[(0, 'reward.new'), (1, 'reward.payable'), (2, 'reward.bad_details'), (3, 'reward.payed'), (4, 'reward.discarded')]),
        ),
        migrations.AlterField(
            model_name='reward',
            name='vulnerability_type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='core.Vulnerability', null=True),
        ),
        migrations.AlterField(
            model_name='staticpage',
            name='language',
            field=models.IntegerField(default=0, choices=[(0, 'language.russian'), (1, 'language.english')]),
        ),
        migrations.AlterField(
            model_name='staticpage',
            name='status',
            field=models.IntegerField(default=0, choices=[(3, 'page.published'), (1, 'page.in_tanker'), (0, 'page.draft')]),
        ),
    ]
