# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion


def create_financial_units(apps, schema_editor):
    FinancialUnit = apps.get_model('core', 'FinancialUnit')
    db_alias = schema_editor.connection.alias
    FinancialUnit.objects.using(db_alias).bulk_create([
        FinancialUnit(acronym='SEMS'),
        FinancialUnit(acronym='DPMS'),
        FinancialUnit(acronym='MPMS'),
        FinancialUnit(acronym='PSMS'),
        FinancialUnit(acronym='MOMS'),
        FinancialUnit(acronym='INMS'),
        FinancialUnit(acronym='YMMS'),
        FinancialUnit(acronym='MSMS'),
        FinancialUnit(acronym='VSMS'),
        FinancialUnit(acronym='BMMS'),
    ])


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0035_reward_ticket_number'),
    ]

    operations = [
        migrations.CreateModel(
            name='FinancialUnit',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('acronym', models.CharField(unique=True, max_length=128)),
            ],
        ),
        migrations.CreateModel(
            name='Product',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(unique=True, max_length=128)),
                ('abc_url', models.URLField(max_length=256, blank=True)),
                ('financial_unit', models.ForeignKey(to='core.FinancialUnit', on_delete=django.db.models.deletion.PROTECT)),
            ],
        ),
        migrations.CreateModel(
            name='ProductScope',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(unique=True, max_length=128)),
            ],
        ),
        migrations.AddField(
            model_name='product',
            name='scope',
            field=models.ForeignKey(on_delete=django.db.models.deletion.SET_NULL, blank=True, to='core.ProductScope', null=True),
        ),
        migrations.AddField(
            model_name='reward',
            name='product',
            field=models.ForeignKey(related_name='rewards', on_delete=django.db.models.deletion.PROTECT, to='core.Product', null=True),
        ),
        migrations.RunPython(create_financial_units),
    ]
