# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0038_remove_private_data'),
    ]

    operations = [
        migrations.CreateModel(
            name='EditablePage',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('slug', models.SlugField(unique=True, max_length=16)),
                ('order', models.IntegerField()),
            ],
        ),
        migrations.CreateModel(
            name='PageTranslation',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('status', models.CharField(max_length=16, choices=[('draft', 'page.draft'), ('uploaded', 'page.uploaded'), ('downloaded', 'page.downloaded'), ('published', 'page.published')])),
                ('title_ru', models.CharField(max_length=255)),
                ('text_ru', models.TextField()),
                ('html_ru', models.TextField()),
                ('title_en', models.CharField(max_length=255, null=True, blank=True)),
                ('text_en', models.TextField(null=True, blank=True)),
                ('html_en', models.TextField(null=True, blank=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('page', models.ForeignKey(to='core.EditablePage')),
            ],
        ),
        migrations.AlterUniqueTogether(
            name='pagetranslation',
            unique_together=set([('page', 'status')]),
        ),
    ]
