import mimetypes
from django.conf import settings
from urllib import quote_plus
from .captcha import *
from .badge import *


def generate_attachment_name(file_name, mime_type):
    extension = mimetypes.guess_extension(mime_type)
    return file_name + extension if extension else file_name

def get_postregistration_url(retpath):
    return ((settings.YAUTH_PASSPORT_URLS['desktop']['subscribe'] % 'mail')
            + quote_plus(retpath))
