import logging
from contextlib import closing
from urllib import urlopen
from xml.etree import ElementTree as ET

from django.conf import settings


__all__ = ['Captcha',]

logger = logging.getLogger(__name__)


class Captcha(object):

    def __init__(self, key=None):
        self.url = None
        if key is not None:
            self.key = key
        else:
            self._init_captcha()

    def _init_captcha(self):
        with closing(urlopen(settings.CAPTCHA_GET)) as conn:
            captcha = ET.parse(conn).getroot()
        self.key = captcha.text
        self.url = captcha.get('url')

    def is_invalid(self, value):
        url = settings.CAPTCHA_CHECK % (self.key, value)
        with closing(urlopen(url)) as conn:
            return  ET.parse(conn).getroot().text != 'ok'


class CaptchaMock(object):
    """Mock class for tests."""

    def __init__(self, key=None):
        self.key = key

    def is_invalid(self, value):
        return self.key != value

    @staticmethod
    def generate_captcha():
        return 'key', 'url'

    @staticmethod
    def check_captcha(key, value):
        return key == value
