# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models
from django.utils.encoding import python_2_unicode_compatible


__all__ = ['Product', 'ProductScope', 'FinancialUnit']


@python_2_unicode_compatible
class Product(models.Model):
    title = models.CharField(max_length=128, unique=True)
    abc_url = models.URLField(max_length=256, blank=True)
    scope = models.ForeignKey('ProductScope', blank=True, null=True, on_delete=models.SET_NULL)
    financial_unit = models.ForeignKey('FinancialUnit', on_delete=models.PROTECT)

    def __str__(self):
        return self.title


@python_2_unicode_compatible
class ProductScope(models.Model):
    title = models.CharField(max_length=128, unique=True)

    def __str__(self):
        return self.title


@python_2_unicode_compatible
class FinancialUnit(models.Model):
    acronym = models.CharField(max_length=128, unique=True)

    def __str__(self):
        return self.acronym
