# coding: utf-8
from __future__ import absolute_import, unicode_literals


def create_profile(manager, config, profile_type):
    return {
        'ENGINE': 'django_pgaas.backend',
        'NAME': config.pg_name,
        'USER': config.pg_user,
        'PASSWORD': config.pg_password,
        'HOST': manager.host_string,
        'PORT': config.pg_port,
        'OPTIONS': {
            'sslmode': 'verify-full',
            'sslrootcert': '/etc/ssl/certs/ca-certificates.crt',
            'target_session_attrs': profile_type
        },
    }
