import requests
from django.conf import settings
import logging


log = logging.getLogger(__name__)


class Storage(object):

    """Class for image storage (avatarnica). """

    def __init__(self):
        self.write_url = settings.AVATARNICA_WRITE
        self.get_url = settings.AVATARNICA_READ
        self.delete_url = settings.AVATARNICA_DELETE

    def put(self, key, filename):
        files = dict(
            file=('file', open(filename, 'rb'))
        )
        params = dict(id=key)
        r = requests.post(self.write_url, files=files, params=params)

        if r.status_code != 200:
            log.critical(r.text)
            raise Exception(r.text)
            # TODO: right exception

        url = self.get_url % dict(key=key)
        return url

    def delete(self, key):
        r = requests.delete(self.delete_url % dict(key=key))
        if r.status_code == 404:
            # already deleted
            return
        if r.status_code != 200:
            # other codes are error
            log.critical(r.text)
            raise Exception(r.text)
            # TODO: right exception
