# coding: utf-8
from __future__ import unicode_literals

import requests

from django.conf import settings

from core.utils.tvm import get_tvm_ticket


class DataSyncException(Exception):
    pass


def update_or_create_payment_info_entry(uid, entry_dict):
    entry_id = entry_dict['id']
    url = '{base_url}/profile/{profile}/{id}'.format(
        base_url=settings.DATASYNC_URL,
        profile=settings.DATASYNC_PROFILE,
        id=entry_id,
    )
    headers = {
        'X-Ya-Service-Ticket': get_tvm_ticket(settings.DATASYNC_TVM_ID),
        'X-Uid': unicode(uid),
    }
    result = requests.put(url, headers=headers, json=entry_dict)
    if result.status_code != 200:
        raise DataSyncException('Could not write object to DataSync with id={}'.format(entry_id))
    return True


def get_payment_info_entry(uid, entry_id):
    url = '{base_url}/profile/{profile}/{id}'.format(
        base_url=settings.DATASYNC_URL,
        profile=settings.DATASYNC_PROFILE,
        id=entry_id,
    )
    headers = {
        'X-Ya-Service-Ticket': get_tvm_ticket(settings.DATASYNC_TVM_ID),
        'X-Uid': unicode(uid),
    }
    result = requests.get(url, headers=headers)
    if result.status_code != 200:
        raise DataSyncException('Could not read object from DataSync with id={}'.format(entry_id))
    return result.json()
