# coding: utf-8
from __future__ import unicode_literals

from django.conf import settings
from tvm2 import TVM2
from tvm2.exceptions import NotAllTicketsException


def get_tvm_client():
    return TVM2(
        client_id=settings.TVM2_CLIENT_ID,
        secret=settings.TVM2_SECRET,
        blackbox_client=settings.TVM_INTERNAL_BLACKBOX_CLIENT,
        destinations=settings.TVM_DESTINATIONS,
        allowed_clients=None,  # пока что никто в нас не ходит
    )


def get_tvm_ticket(destination):
    tvm_client = get_tvm_client()
    if destination not in tvm_client.destinations:
        tvm_client.add_destinations(destination)
    tickets = tvm_client.get_service_tickets(destination)
    if destination in tickets and tickets[destination]:
        return tickets[destination]
    else:
        raise NotAllTicketsException()
