# -*- coding: utf-8 -*-
from __future__ import absolute_import
from __future__ import unicode_literals

from django.conf import settings

from django_yauth.util import get_current_host


__all__ = ['get_validator_url']


def get_validator_url(request=None):
    validator_url = settings.VALIDATOR_URL

    if request:
        host = get_current_host(request)

        for tail in ('.com', '.com.tr'):
            if host.endswith(tail):
                validator_url = validator_url.replace('.ru/', '%s/' % tail, 1)
                break

    return validator_url
