# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.core.validators import RegexValidator
from django.utils.translation import ugettext_lazy as _


class IBANValidator(RegexValidator):
    # IBAN - https://ru.wikipedia.org/wiki/IBAN_%28ISO_13616%29
    regex = r'^[A-Za-z]{2}[0-9]{2}[0-9a-zA-Z]{5,30}$'
    message = _("IBAN format: 2 characters, then 2 digits and from 5 to 30 latin characters or digits")


class SWIFTValidator(RegexValidator):
    # SWIFT - https://ru.wikipedia.org/wiki/ISO_9362
    regex = r'^[A-Za-z]{6}[A-Za-z0-9]{2}([A-Za-z0-9]{3})?$'
    message = _("SWIFT format: 8 characters and maybe 3 latin characters or digits")


class BICValidator(RegexValidator):
    #https://ru.wikipedia.org/wiki/%D0%91%D0%B0%D0%BD%D0%BA%D0%BE%D0%B2%D1%81%D0%BA%D0%B8%D0%B9_%D0%B8%D0%B4%D0%B5%D0%BD%D1%82%D0%B8%D1%84%D0%B8%D0%BA%D0%B0%D1%86%D0%B8%D0%BE%D0%BD%D0%BD%D1%8B%D0%B9_%D0%BA%D0%BE%D0%B4
    regex = r'04[0-9]{7}'
    message = _("BIC format: 04 and 7 digits")


class SNILSValidator(RegexValidator):
    regex = r'[0-9]{3}-[0-9]{3}-[0-9]{3}(-| )[0-9]{2}'
    message = _('SNILS format: 000-000-000-00 or 000-000-000 00')
