# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from urllib import quote

from django.conf import settings
from django.core.urlresolvers import reverse
from django_yauth.util import get_passport_url, get_yauth_type
from django_yauth.context import yauth as yauth_context

from app.utils import locale as locale_utils


def yauth(request):

    context = yauth_context(request)
    yauth_type = get_yauth_type(request)

    def yu():
        yandexuid = request.COOKIES.get('yandexuid')
        if yandexuid:
            return '&yu=%s' % yandexuid
        return ''

    def get_main_url():
        return request.build_absolute_uri(reverse('main'))

    logout_url = ''.join((get_passport_url('delete', yauth_type, request),
                          quote(get_main_url()), yu()))
    context['logout_url'] = logout_url
    return context


def feedback_url(request):
    return {'feedback_url':
            settings.FEEDBACK_URLS.get(request.LANGUAGE_CODE, None)}


def localized_page_url(request):
    localized_url = locale_utils.LocalizedUrl(request.build_absolute_uri())
    return {'russian_page_url': localized_url.get_russian(),
            'english_page_url': localized_url.get_english()}
