# -*- coding: utf-8 -*-
from __future__ import absolute_import
from __future__ import unicode_literals

from functools import partial
from functools import wraps

from django.contrib.auth.decorators import user_passes_test
from django.shortcuts import redirect
from django.utils.decorators import available_attrs


__all__ = [
    'yalogin_required_redirect', 'anonymous_only_redirect',
    'email_required_redirect', 'no_email_only_redirect',
]


def yauser_passes_test(test_func, redirect_url=None, **test_func_kwargs):

    def decorator(view_func):

        @wraps(view_func, assigned=available_attrs(view_func))
        def _wrapped_view(request, *args, **kwargs):
            if test_func(request.yauser, **test_func_kwargs):
                return view_func(request, *args, **kwargs)
            return redirect(redirect_url)

        return _wrapped_view

    return decorator


def check_yalogin(yauser, require_anonymous):
    return require_anonymous ^ yauser.is_authenticated()


yalogin_required_redirect = partial(yauser_passes_test, check_yalogin, require_anonymous=False)

anonymous_only_redirect = partial(yauser_passes_test, check_yalogin, require_anonymous=True)


def check_email(yauser, require_no_email):
    return require_no_email ^ bool(yauser.default_email)


email_required_redirect = partial(yauser_passes_test, check_email, require_no_email=False)

no_email_only_redirect = partial(yauser_passes_test, check_email, require_no_email=True)
