# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django import template
from django.utils.text import Truncator


register = template.Library()


@register.filter(name='mask_passport_number')
def mask_passport_number(number):
    if number is None or len(number) <=4:
        return number
    head = number[:2]
    body = number[2:-2]
    tail = number[-2:]
    truncated = Truncator(body).chars(2, truncate='%(truncated_text)s**')
    return ''.join([head, truncated, tail])
