# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import urlparse


class LocalizedUrl(object):

    def __init__(self, url):
        self._url = url
        self._parsed = urlparse.urlsplit(url)
        self._hostname = self._parsed.hostname
        self._port = self._parsed.port

    def get_russian(self):
        if self._hostname.endswith('.ru'):
            return self._url
        else:
            return self._url_for('ru')

    def get_english(self):
        if self._hostname.endswith('.com'):
            return self._url
        else:
            return self._url_for('com')

    def _url_for(self, tld):
        scheme, _, path, query, fragment = self._parsed
        return urlparse.urlunsplit(
            urlparse.SplitResult(scheme=scheme,
                                 netloc=self._hostname_for(tld),
                                 path=path,
                                 query=query,
                                 fragment=fragment))

    def _hostname_for(self, tld):
        domain = self._hostname.rsplit('.', 1)[0]
        hostname = '.'.join([domain, tld])
        if self._port:
            hostname = '%s:%s' % (hostname, self._port)
        return hostname
