# coding: utf-8
from __future__ import absolute_import, unicode_literals

import re


def blank(value, start=1, end=-1):
    if end == 0:
        end = len(value)

    if len(value) < 4:
        return '*' * len(value)

    if value.startswith('+'):
        start = 2
        end = -2

    if '@' in value:
        login, domain = value.split('@', 1)
        return '@'.join([blank(login), domain])

    if re.compile('\d{4}-\d{2}-\d{2}').match(value):
        start = 5

    if re.compile('\d{3}-.*').match(value) and len(value) > 10:
        start = 4
        end = -2

    if len(value) > 10 and value.isdigit():
        start = len(value) * 1 // 4
        end = -2

    if start + abs(end) >= len(value):
        start = 1
        end = -1

    return value[:start] + re.sub('[a-zA-Zа-яА-Я0-9]', '*', value[start:end]) + value[end:]
