module.exports = function(grunt) {

	// Project configuration.
	grunt.initConfig({
		pkg: grunt.file.readJSON('package.json'),
		concat: {
			jsDev: {
				src: [
					'libs/jquery/jquery.min.js',
					'libs/live/live.js',
					'src/js/base.js',
					'src/js/forms-common.js',
				],
				dest: 'dest/js/scripts.js'
			},
			js: {
				src: [
					'libs/jquery/jquery.min.js',
					'src/js/base.js',
					'src/js/forms-common.js',
				],
				dest: 'dest/js/scripts.js'
			}
		},
		uglify: {
			js: {
				files: {
					'dest/js/scripts.js': 'dest/js/scripts.js'
				}
			}
		},
		cssjoin: {
			join: {
				files: {
					'dest/css/style.css': ['src/css/style.css'],
				},
			}
		},
		autoprefixer: {
			options: {
				browsers: ['last 2 version']
			},
			dev: {
				src: 'dest/css/style.css'
			}
		},
		cssmin: {
			options: {
				report: 'gzip'
			},
			files: {
				src: 'dest/css/style.css', 
				dest: 'dest/css/style.css'
			}
		},
		copy: {
			img: {
				files: [
					{cwd: 'src/', src: 'images/**/*', dest: 'dest/', expand: true},
					{cwd: 'src/', src: 'fonts/**/*', dest: 'dest/', expand: true},
					{cwd: 'src/', src: '*', dest: 'dest/', filter: 'isFile', expand: true, flatten: true}
				]	
			},
			js: {
				files: [
					{cwd: 'src/', src: 'js/frame.js', dest: 'dest/', expand: true},
                ]	
            }
		},
		clean: {
			build: {
				src: 'dest'
			}
		},
		watch: {
			js: {
				files: [
					'src/js/*.js'
				],
				tasks: ['concat:jsDev']
			},
			files: {
				files: [
					'src/images/**/*',
					'src/images/*',
					'src/*.html'
				],
				tasks: ['copy']
			},
			css: {
				files: ['src/css/*'],
				tasks: ['cssjoin', 'autoprefixer']
			}
		}
	});

	// Load the plugin
	grunt.loadNpmTasks('grunt-contrib-concat');
	grunt.loadNpmTasks('grunt-contrib-uglify');
	grunt.loadNpmTasks('grunt-contrib-watch');
	grunt.loadNpmTasks('grunt-autoprefixer');
	grunt.loadNpmTasks('grunt-contrib-copy');
	grunt.loadNpmTasks('grunt-contrib-clean');
	grunt.loadNpmTasks('grunt-cssjoin');
	grunt.loadNpmTasks('grunt-css');

	// Default task(s).
	grunt.registerTask('default', ['clean', 'concat:jsDev', 'cssjoin', 'autoprefixer', 'copy']);
	grunt.registerTask('build', ['clean', 'concat:js', 'cssjoin', 'autoprefixer', 'copy', 'uglify', 'cssmin']);
	grunt.registerTask('del', ['clean']);

};
