$(document).ready(function() {

    $('.user_header').css('float', 'right');

    $(".user").each(function() {
        var par = $(this),
            pop = $(".user__pop", this),
            name = $(".user__name", this).outerWidth();

        par.click(function() {
            $(this).toggleClass('user_pop');
        });
    });

    function userClose() {
        $('.user').removeClass('user_pop');
    }

    $(document).click(function(e) {
        if (!$(e.target).closest('.user').length) {
            userClose();
        }
    });

    var check_file_size = function() {
        var doc = document.getElementById("document");
        var files = doc.files;
        if (files.length === 1) {
            var isCorrectSize = files[0].size < 5 * 1024 * 1024;
            $("#document_size_error").toggleClass("hidden", isCorrectSize);
            return isCorrectSize;
        } else {
            return true;
        }
    }

    var check_filename_length = function() {
        var doc = document.getElementById("document");
        var files = doc.files;
        if (files.length === 1) {
            var isCorrectNameLength = files[0].name.length < 65;
            $("#document_name_length_error").toggleClass("hidden", isCorrectNameLength);
            return isCorrectNameLength;
        } else {
            return true;
        }
    }

    var update_submit_button_state = function() {
        var isFileSizeCorrect = check_file_size();
        var isFileNameCorrect = check_filename_length();
        var isAcceptChecked = $("#accept_checkbox")[0].checked;
        $('.button').last().toggleClass('button_disable_yes', !isAcceptChecked || !isFileSizeCorrect || !isFileNameCorrect);
    }

    var update_not_russian_account_type = function() {
        var account_type = $('.js-sel_account-type > select').val()
        var account = $('.account_field')
        var ben_account = $('.ben_account_field')
        if (account_type == 'account') {
            account.removeClass('hidden')
            ben_account.addClass('hidden')
        } else if (account_type == 'ben_account') {
            ben_account.removeClass('hidden')
            account.addClass('hidden')
        } else {
            ben_account.addClass('hidden')
            account.addClass('hidden')
        }
    }

    $("#document").change(update_submit_button_state);

    $('#id_is_russian_resident').click(function() {
        var state = $('#id_is_russian_resident:checked').size();
        if (state) {
            $('.russian_resident_field').removeClass('hidden');
            $('.not_russian_resident_field').addClass('hidden');
        } else {
            $('.russian_resident_field').addClass('hidden');
            $('.not_russian_resident_field').removeClass('hidden');
            update_not_russian_account_type();
        }
    });

    $('input[type=radio][name=bank_type]').on('change', function() {
        switch ($(this).val()) {
            case '0':
                $('.bank_field').addClass('hidden');
                $('.another_bank_field').addClass('hidden');
                $('.yamoney_field').addClass('hidden');
                $('.payoneer_field').addClass('hidden');
                break;
            case '1':
                $('.bank_field').removeClass('hidden');
                $('.another_bank_field').addClass('hidden');
                $('.yamoney_field').addClass('hidden');
                $('.payoneer_field').addClass('hidden');
                break;
            case '2':
                $('.bank_field').removeClass('hidden');
                $('.another_bank_field').removeClass('hidden');
                $('.yamoney_field').addClass('hidden');
                $('.payoneer_field').addClass('hidden');
                break;
            case '3':
                $('.bank_field').addClass('hidden');
                $('.another_bank_field').addClass('hidden');
                $('.yamoney_field').removeClass('hidden');
                $('.payoneer_field').addClass('hidden');
                break;
            case '7':
                $('.bank_field').addClass('hidden');
                $('.another_bank_field').addClass('hidden');
                $('.yamoney_field').addClass('hidden');
                $('.payoneer_field').removeClass('hidden');
                break;
        }
    });

    $('#accept_checkbox').click(update_submit_button_state);

    $('.reload_captcha').click(function(e) {
        e.preventDefault();
        $.ajax({
            type: 'GET',
            url: '/bugbounty/captcha/',
        }).done(function(data) {
            captcha = data['captcha']
            $(".captcha_image").attr('src', captcha[1]);
            $(".captcha_key").attr('value', captcha[0]);
        });
    });

    // input
    $('.input').each(function() {
        var par = $(this),
            inp = $('.input__input', this),
            tmpl = '<div class="input__clear"></div>';

        $(tmpl).appendTo(par);
        clear = $('.input__clear', this);

        function inputEmpty() {
            if (inp.val() != '') {
                par.removeClass('input_state_empty');
            } else {
                par.addClass('input_state_empty');
            }
        };

        inputEmpty();

        inp.keyup(function() {
            inputEmpty();
        });

        clear.click(function(e) {
            e.preventDefault();

            inp.val('');
            par.addClass('input_state_empty');
        });
    });

    // textarea
    $('.textarea').each(function() {
        var par = $(this),
            text = $('.textarea__textarea', this),
            tmpl = '<div class="textarea__clear"></div>';

        $(tmpl).appendTo(par);
        clear = $('.textarea__clear', this);

        function textareaEmpty() {
            if (text.val() != '') {
                par.removeClass('textarea_state_empty');
            } else {
                par.addClass('textarea_state_empty');
            }
        };

        textareaEmpty();

        text.keyup(function() {
            textareaEmpty();
        });

        clear.click(function(e) {
            e.preventDefault();

            text.val('');
            par.addClass('textarea_state_empty');
        });
    });

    // js-sel
    $('.js-sel').each(function() {
        var par = $(this),
            sel = $('SELECT', this),
            options = $('OPTION', sel),
            tmpl = '<span class="js-sel__head"><span class="js-sel__head__txt"></span><span class="js-sel__arrow"></span></span><ul class="js-sel__body"></ul>',
            head, head_text, body, body_items,
            placeholder = par.attr('data-placeholder');

        $(tmpl).appendTo(par);

        body = $('.js-sel__body', par);
        options.each(function() {
            var cl = $(this).is(':selected') ? 'cur ' : '';
            $('<li data-id="' + $(this).attr('value') + '" class="' + cl + '"><span>' + $(this).text() + '</span></li>').appendTo(body);
        });

        head = $('.js-sel__head', par);
        if (par.data('placeholder')) {
            head_text = $('.js-sel__head__txt', par).text(placeholder);
            $('.js-sel__head__txt', par).addClass('js-sel__head__txt_def');
            $('.js-sel__body LI', par).removeClass('cur');
        } else {
            head_text = $('.js-sel__head__txt', par).text($(':selected', sel).text());
            $('.js-sel__head__txt', par).attr('data-id', $(':selected', sel).attr('value'));
        }
        body_items = $('.js-sel__body LI', par);

        body_items.on('click', function() {
            $(this).addClass('cur').siblings().removeClass('cur');
            head_text.text($(this).text());
            $('.js-sel__head__txt', par).removeClass('js-sel__head__txt_def')
            options.eq($(this).prevAll().length).prop('selected', 'selected');
            selClose();

            if (window.location.href.search('hof') != -1) {
                var year = $('.js-sel_year').find('.js-sel__head__txt').html();
                var month = $('.js-sel_month').find('li.cur').attr('data-id');

                var schema = window.location.protocol + '//';
                var date_path = '/bugbounty/hof/' + year + '/' + month + '/';
                var date_url = schema + window.location.host + date_path;
                window.location.replace(date_url);
            }

            if (window.location.href.search('pay') != 1) {
                update_not_russian_account_type();
            }
        });

        head.click(function() {
            if (!par.hasClass('js-sel_open')) {
                selClose();
                par.addClass('js-sel_open');
            } else {
                par.removeClass('js-sel_open');
            }
        });

    });

    function selClose() {
        $('.js-sel').removeClass('js-sel_open');
    }

    $(document).click(function(e) {
        if (!$(e.target).closest('.js-sel').length) {
            selClose();
        }
    });

    initChk('.check');

    function initChk(sel) {
        $(sel).each(function() {
            var par = $(this),
                inp = $(':checkbox, :radio', this);
            inp.is(':checked') ? par.addClass('checked') : par.removeClass('checked');
            inp.is(':disabled') ? par.addClass('disabled') : par.removeClass('disabled');

            inp.on('change click', function() {
                inp.is(':checked') ? par.addClass('checked') : par.removeClass('checked');

                if (par.hasClass('check_mode_radio')) {
                    $('.check_mode_radio input[name=' + inp.attr('name') + ']').each(function() {
                        $(this).is(':checked') ? $(this).closest('.check_mode_radio').addClass('checked') : $(this).closest('.check_mode_radio').removeClass('checked');
                    });
                }
            });
        });
    }

    // lang
    $('.lang').each(function() {
        var par = $(this),
            h = $('.lang__h', par);
        h.on('click', function(e) {
            e.preventDefault();
            par.toggleClass('selector');
        });
        h.on('click', function(e) {
            e.preventDefault();
            if (!par.hasClass('lang_open')) {
                langClose();
                par.addClass('lang_open');
            } else {
                par.removeClass('lang_open');
            }
        });
    });

    function langClose() {
        $('.lang').removeClass('lang_open');
    }

    $(document).click(function(e) {
        if (!$(e.target).closest('.lang__h').length) {
            langClose();
        }
    });


}); // dom ready