module.exports = function(grunt) {

	// Project configuration.
	grunt.initConfig({
		pkg: grunt.file.readJSON('package.json'),
		concat: {
			jsDev: {
				src: [
					'libs/jquery/jquery.min.js',
					'libs/tablesorter/jquery.tablesorter.min.js',
                    'libs/typeahead.js/dist/typeahead.bundle.min.js',
					'libs/live/live.js',
					'libs/jquery.browser/dist/jquery.browser.min.js',
					'src/js/main.js',
					'src/js/base.js'
				],
				dest: 'dest/js/scripts.js'
			},
			js: {
				src: [
					'libs/jquery/jquery.min.js',
					'libs/tablesorter/jquery.tablesorter.min.js',
                    'libs/typeahead.js/dist/typeahead.bundle.min.js',
					'libs/jquery.browser/dist/jquery.browser.min.js',
					'src/js/main.js',
					'src/js/base.js'
				],
				dest: 'dest/js/scripts.js'
			}
		},
		cssjoin: {
			join: {
				files: {
					'dest/css/style.css': ['src/css/style.css'],
				},
			}
		},
		uglify: {
			js: {
				files: {
					'dest/js/scripts.js': 'dest/js/scripts.js'
				}
			}
		},
		autoprefixer: {
			options: {
				browsers: ['last 2 version']
			},
			dev: {
				src: 'dest/css/style.css'
			}
		},
		cssmin: {
			options: {
				report: 'gzip'
			},
			files: {
				src: 'dest/css/style.css', 
				dest: 'dest/css/style.css'
			}
		},
		copy: {
			img: {
				files: [
					{cwd: 'src/', src: 'css/bem/i/*.svg', dest: 'dest/css/i/', flatten: true, expand: true},
					{cwd: 'src/', src: 'css/bem/i/*.png', dest: 'dest/css/i/', flatten: true, expand: true},
					{cwd: 'src/', src: 'images/**/*', dest: 'dest/', expand: true},
					{cwd: 'src/', src: 'fonts/**/*', dest: 'dest/', expand: true},
					{cwd: 'src/', src: '*', dest: 'dest/', filter: 'isFile', expand: true, flatten: true},
					{cwd: 'src/', src: 'admin/**', dest: 'dest', expand: true, flatten:false},
					{cwd: 'src/', src: 'rest_framework/**', dest: 'dest', expand: true, flatten:false},
				]	
			}
		},
		clean: {
			build: {
				src: 'dest'
			}
		},
		watch: {
			js: {
				files: [
					'src/js/*.js'
				],
				tasks: ['concat:jsDev']
			},
			files: {
				files: [
					'src/css/bem/i/*',
					'src/images/**/*',
					'src/images/*',
					'src/fonts/**/*',
					'src/*.html'
				],
				tasks: ['copy']
			},
			css: {
				files: [
					'src/css/*',
					'src/css/bem/*'
					],
				tasks: ['cssjoin', 'autoprefixer']
			}
		},
		'sftp-deploy': {
			build: {
				auth: {
					host: 'yasap-dev.yandex.ru',
					port: 22,
					authKey: 'key1'
				},
				src: 'dest',
				dest: '/place/home/ssamsonov/www/bugbounty',
				server_sep: '/'
			}
		}
	});

	// Load the plugin
	grunt.loadNpmTasks('grunt-contrib-concat');
	grunt.loadNpmTasks('grunt-contrib-uglify');
	grunt.loadNpmTasks('grunt-contrib-watch');
	grunt.loadNpmTasks('grunt-autoprefixer');
	grunt.loadNpmTasks('grunt-contrib-copy');
	grunt.loadNpmTasks('grunt-contrib-clean');
	grunt.loadNpmTasks('grunt-cssjoin');
	grunt.loadNpmTasks('grunt-css');
	grunt.loadNpmTasks('grunt-sftp-deploy');

	// Default task(s).
	grunt.registerTask('default', ['clean', 'concat:jsDev', 'cssjoin', 'autoprefixer', 'copy']);
	grunt.registerTask('build', ['clean', 'concat:js', 'cssjoin', 'autoprefixer', 'copy', 'uglify', 'cssmin']);
	grunt.registerTask('del', ['clean']);
	grunt.registerTask('deploy', ['clean', 'concat:js', 'cssjoin', 'autoprefixer', 'copy', 'uglify', 'cssmin', 'sftp-deploy']);

};
