var app = {};

$(document).ready(function() {
    $('.input__input').slice(-2).keyup(function(event) {
        var is_valid = $('.input__input').slice(-2).toArray().map(function(input) {
            return input.value;
        }).reduce(function(mem, value) {
            return mem && value
        }, true);
        if(is_valid) {
           $('.control_buttons .button').removeClass('button_disable_yes'); 
        } else {
           $('.control_buttons .button').addClass('button_disable_yes'); 
        }
    });
    $('.username_suggest').typeahead(
        {
            minLength: 1,
            hint: true,
            highLight: true
        },
        {
            name: 'users',
            displayKey: 'username',
            source: function(q, cb){
                    $.ajax({
                        type: 'GET',
                        url: "/suggest/user/",
                        data: {text: q},
                    }).done(function(data) {
                        cb(data);
                    });
                }
        }
    );
	// user
	$('.user').each(function() {
		var par = $(this),
			pop = $('.user__pop', this),
			name = $('.user__name', this).outerWidth();

		if (name < 50) {
			pop.addClass('user__pop_right');
			pop.css('right', name + 14);
		} else {
			pop.removeClass('user__pop_right');
			pop.attr('css', '');
		}

		par.click(function() {
			$(this).toggleClass('user_pop');
		});
	});

	function userClose() {
		$('.user').removeClass('user_pop');
	}

	$(document).click(function(e) {
		if (!$(e.target).closest('.user').length) {
			userClose();
		}
	});

	// input
	$('.input').each(function() {
		// Sorry, I'm just that bad in JS   T_T
		// I don't understand what is going on here so I just quit
		if ($(this).hasClass("ignore_js_templating")) {
			return;
		}
		var par = $(this),
			inp = $('.input__input', this),
			tmpl = '<div class="input__clear"></div><div class="input__ground"></div>';

		$(tmpl).appendTo(par);
		clear = $('.input__clear', this);
		par.addClass('input_type_normal');

		inp.focus(function() {
			par.addClass('input_focus_yes');
		});

		inp.blur(function() {
			par.removeClass('input_focus_yes');
		});

		function inputEmpty() {
			if (inp.val() != '') {
				par.removeClass('input_state_empty').addClass('input_state_filled');
			} else {
				par.addClass('input_state_empty').removeClass('input_state_filled');
			}
		};

		inputEmpty();

		inp.keyup(function() {
			inputEmpty();
		});

		clear.click(function(e) {
			e.preventDefault();

			inp.val('');
			par.addClass('input_state_empty').removeClass('input_state_filled');
            
            var keyup = jQuery.Event('keyup');
            inp.trigger(keyup);
		});
	});

	// textarea
	$('.textarea').each(function() {
		var par = $(this),
			text = $('.textarea__textarea', this),
			tmpl = '<div class="textarea__clear"></div><div class="textarea__ground"></div>';

		$(tmpl).appendTo(par);
		clear = $('.textarea__clear', this);
		par.addClass('textarea_type_normal');

		text.focus(function() {
			par.addClass('textarea_focus_yes');
		});

		text.blur(function() {
			par.removeClass('textarea_focus_yes');
		});

		function textareaEmpty() {
			if (text.val() != '') {
				par.removeClass('textarea_state_empty').addClass('textarea_state_filled');
			} else {
				par.addClass('textarea_state_empty').removeClass('textarea_state_filled');
			}
		};

		textareaEmpty();

		text.keyup(function() {
			textareaEmpty();
		});

		clear.click(function(e) {
			e.preventDefault();

			text.val('');
			par.addClass('textarea_state_empty').removeClass('textarea_state_filled');
		});
	});

	// radiogroup
	$('.radiogroup').each(function() {
		var par = $(this),
			radio = $('.button_mode_radio', this),
			checked = $('.button_state_check', this);

		function radioCheck(el) {
			var data = el.data('radio');

			if (data) {
				$('.r-content-' + par.data('group')).hide();
				// $('#' + par.data('group') + '-' + data).show();
				$('.r-content-' + par.data('group') + '_' + data).show();
			};
		};

		radioCheck(checked);

		radio.click(function(e) {
			e.preventDefault();
			var inp = $(':radio', this);

			inp.prop('checked', 'checked');
			$(this).addClass('button_state_check').siblings().removeClass('button_state_check');

			radioCheck($(this));
		});
	});

	// button
	$('.button').each(function() {
		var btn = $(this),
			arr = $('.button__arrow', this),
			label = $('.button__label', this),
			tmpl = '<span class="button__ground"></span>';

		$(tmpl).prependTo(btn);

		btn.mousedown(function() {
			if ($(this).hasClass('button_open')) {
				return
			};
			$(this).addClass('button_state_press');
		});
		btn.mouseup(function() {
			$(this).removeClass('button_state_press');
		});
		btn.mouseout(function() {
			$(this).removeClass('button_state_press');
		});

		if (btn.hasClass('button_type_pseudo')) {
			var	pseudoTmpl = '<span class="button__border"></span>';
			$(pseudoTmpl).prependTo(btn);
		} if (btn.hasClass('button_mode_next') || btn.hasClass('button_mode_back')) {
			var	pseudoTmpl = '<span class="button__arrow"></span>';
			$(pseudoTmpl).prependTo(btn);
		} if (btn.hasClass('button_mode_check') && !btn.closest('.check').length) {
			btn.click(function(e) {
				e.preventDefault();
				var inp = $(':checkbox', this);
			
				inp.prop('checked', !inp.prop('checked'));

				if ($(this).closest('.checkgroup').hasClass('checkgroup_fix')) {
					var col = $(this).parents('.checkgroup').find('.button_state_check').length;
					if (col < 2) {
						$(this).addClass('button_state_check');
						inp.prop('checked', 'checked');
					} else {
						$(this).toggleClass('button_state_check');
					}
				} else {
					$(this).toggleClass('button_state_check');
				}
			});
		} else if (btn.hasClass('button_radio')) {

			var	item = $('LI>LABEL', this);

			item.click(function(e) {
				e.preventDefault();
				var val = $(this).text(),
					inp = $(':radio', this);

				item.parent().removeClass('checked');
				inp.prop('checked', 'checked');

				if (inp.is(':checked')) {
					$(this).parent().addClass('checked');
					label.text(val);
				} else {
					$(this).parent().removeClass('checked');
				}

				btn.addClass('button_state_check').siblings().removeClass('button_state_check');
			});


		} if (btn.hasClass('button_mode_dropdown') || btn.hasClass('button_mode_dropup')) {
			var body = $('>UL', this),
				l = $(this).offset().left,
				bodyWidth = body.outerWidth(),
				w = $(window).width();

			if (l + bodyWidth + 200 > w) {
				body.addClass('right');
			} else {
				body.removeClass('right');
			}

			if (l + bodyWidth + 20 > w) {
				body.css({
					left: 'auto',
					right: 0
				});
			} else {
				body.css({
					left: 0,
					right: 'auto'
				});
			}

			btn.click(function(e) {
				if (!btn.hasClass('button_open')) {
					btnClose();
					btn.addClass('button_open');
					arr.addClass('button__arrow_state_open');
				} else if ($(e.target).closest('.check').length) {
					return false;
				} else {
					btn.removeClass('button_open');
					arr.removeClass('button__arrow_state_open');
				}
			});
		};
	});

	function btnClose() {
		$('.button_mode_dropdown, .button_mode_dropup').removeClass('button_open');
		$('.button_mode_dropdown .button__arrow, .button_mode_dropup .button__arrow').removeClass('button__arrow_state_open');
	}

	$(document).click(function(e) {
		if (!$(e.target).closest('.button_mode_dropdown, .button_mode_dropup, .js-select').length) {
			btnClose();
		}
	});

	// button_toggle
	$('.button_toggle').each(function() {
		var par = $(this),
			label = $('.button__label', this);

		par.click(function(e) {
			e.preventDefault();

			var inp = $(':checkbox', this);
			inp.prop('checked', !inp.prop('checked'));
			par.toggleClass('button_type_normal').toggleClass('button_type_action')
			label.toggle();
		});
	});

	// checkbox & radio
	$('.check').each(function() {
		var par = $(this),
			inp = $(':checkbox, :radio', this),
			label = $('>SPAN', this).addClass('check__label'),
			tmplCheckbox = '<button class="button button_size_M button_type_normal button_mode_check"><span class="button__label button__label_empty_yes"></span><span class="button__ground"></span><span class="button__tip"></span></button>',
			tmplRadio = '<button class="button button_size_M button_type_normal button_mode_radio"><span class="button__label button__label_empty_yes"></span><span class="button__ground"></span><span class="button__tip"></span></button>',
			is_radio = par.hasClass('check_radio'),
			btn;

		par.prepend(is_radio ? tmplRadio : tmplCheckbox);
		btn = $('.button_mode_check, .button_mode_radio', par);

		if (par.hasClass('check_disable_yes')) {
			btn.addClass('button_disable_yes');
		};

		par.click(function(e) {
			e.preventDefault();

			if (is_radio) {
				inp.prop('checked', 'checked');
				check($('.check_radio:has(input[name=' + inp.attr('name') + '])'));
			} else {
				inp.prop('checked', !inp.prop('checked'));
				check(this);
			}
		});

		function check(el) {
			$(el).each(function() {
				var par = $(this),
					inp = $(':checkbox, :radio', this);

				if (inp.is(':checked')) {
					par.addClass('checked')
						.find('.button').addClass('button_state_check').end()
							.trigger('check-update')
								.trigger('check-update-check');
				} else {
					par.removeClass('checked')
						.find('.button').removeClass('button_state_check').end()
							.trigger('check-update').trigger('check-update-uncheck');
				}
			})
		}

		check(par);

		if (par.hasClass('check_toggle')) {
			par.on('check-update', function() {
				$('.check_toggle__' + par.data('toggle')).toggle();
			});
		};
	});

	// js-edit
	$('.js-edit').each(function() {
		var par = $(this),
			sel = $('SELECT', this),
			options = $('OPTION', sel),
			tmpl = '<span class="input input_size_M input_type_normal input_state_empty input_mode_dropdown"><input size="1" autocomplete="off" placeholder="" value="" class="input__input"><div class="input__ground"></div><div class="input__arrow"></div></span><ul class="js-edit__body island island_fly"></ul>',
			head, head_text, body, body_items, parent, input, arr,
			placeholder = par.attr('data-placeholder');

		$(tmpl).appendTo(par);

		body = $('.js-edit__body', par);

		options.each(function() {
			var cl = $(this).is(':selected') ? 'cur ' : '';
			$('<li class="' + cl + '"><span>' + $(this).text() + '</span></li>').appendTo(body);
		});

		l = par.offset().left,
		bodyWidth = body.outerWidth(),
		w = $(window).width(),
		parent = $('.input', par),
		input = $('.input__input', parent),
		arr = $('.input__arrow', par),
		head = $('.js-edit__head', par);

		if (par.hasClass('js-edit_size_S')) {
			$('.input', par).removeClass('input_size_M').addClass('input_size_S');
		} if (par.hasClass('js-edit_size_L')) {
			$('.input', par).removeClass('input_size_M').addClass('input_size_L');
		}

		if (par.hasClass('js-edit_up')) {
			$('.input', par).removeClass('input_mode_dropdown').addClass('input_mode_dropup');
		};

		if (par.data('placeholder')) {
			head_text = input.attr('placeholder', placeholder);
			$('.js-edit__body LI', par).removeClass('cur');
		} else {
			head_text = input.val($(':selected', sel).text());
		}
		body_items = $('.js-edit__body LI', par);

		body_items.on('click', function() {
			input.val($(this).text());
			inputVal();
			options.eq($(this).prevAll().length).prop('selected', 'selected');
			editClose();
		});

		if (l + bodyWidth > w) {
			body.css({
				left: 'auto',
				right: 0
			});
		} else {
			body.css({
				left: 0,
				right: 'auto'
			});
		}

		function bodyShow() {
			if (!par.hasClass('js-edit_open')) {
				editClose();
				btnClose();
				par.addClass('js-edit_open');
				arr.addClass('input__arrow_state_open');
			} else {
				par.removeClass('js-edit_open');
				arr.removeClass('input__arrow_state_open');
			}
		};

		input.click(function() {
			bodyShow();
		});

		arr.click(function(e) {
			input.focus();
			bodyShow();
		});

		input.focus(function() {
			parent.addClass('input_focus_yes');
		});

		input.blur(function() {
			parent.removeClass('input_focus_yes');
			input.removeClass('input__input_focus');
		});

		function inputVal() {
			if (input.val() != '') {
				par.removeClass('input_state_empty').addClass('input_state_filled');
			} else {
				par.addClass('input_state_empty').removeClass('input_state_filled');
			}
		};

		inputVal();

		input.keyup(function() {
			inputVal();
		});
	});

	function editClose() {
		$('.js-edit').removeClass('js-edit_open');
		$('.js-edit .input__arrow').removeClass('input__arrow_state_open');
	}

	$(document).click(function(e) {
		if (!$(e.target).closest('.js-edit').length) {
			editClose();
		}
	});

	// js-select
    app.jsSelectInit = function (els) {
        $(els).each(function() {
            var theParent = $(this),
                select = $('SELECT', this),
                options = $('OPTION', select),
                tmpl = '<span class="js-select__head">' +
                            '<span class="button button_size_M button_type_normal button_mode_dropdown wMax">' +
                                '<span class="button__label"></span>' +
                                '<span class="button__ground"></span>' +
                                '<span class="button__arrow"></span>' +
                            '</span>' +
                        '</span>' +
                        '<ul class="js-select__body island island_fly"></ul>',
                head, head_text, body, body_items,
                placeholder = theParent.attr('data-placeholder');

            $(tmpl).appendTo(theParent);

            body = $('.js-select__body', theParent);

            options.each(function () {
                var cl = $(this).is(':selected') ? 'cur ' : '';
                $('<li class="' + cl + '"><span>' + $(this).text() + '</span></li>').appendTo(body);
            });

            l = theParent.offset().left,
                bodyWidth = body.outerWidth(),
                w = $(window).width(),
                head = $('.js-select__head', theParent);

            if (theParent.hasClass('js-select_clear')) {
                $('.button', theParent).removeClass('button_type_normal').addClass('button_type_clear');
            }
            if (theParent.hasClass('js-select_up')) {
                $('.button', theParent).removeClass('button_mode_dropdown').addClass('button_mode_dropup');
            }
            if (theParent.hasClass('js-select_size_S')) {
                $('.button', theParent).removeClass('button_size_M').addClass('button_size_S');
            }
            if (theParent.hasClass('js-select_size_L')) {
                $('.button', theParent).removeClass('button_size_M').addClass('button_size_L');
            }
            if (theParent.hasClass('js-select_disable')) {
                $('.button', theParent).addClass('button_disable_yes');
            }
            ;

            if (theParent.data('placeholder')) {
                head_text = $('.button__label', theParent).text(placeholder);
                $('.button__label', theParent).addClass('button__label_def');
                $('.js-select__body LI', theParent).removeClass('cur');
            } else {
                head_text = $('.button__label', theParent).text($(':selected', select).text());
            }

            $('.js-select__body', theParent).on('click', 'LI', function () {
                $(this).addClass('cur').siblings().removeClass('cur');
                head_text.text($(this).text());
                $('.button__label', theParent).removeClass('button__label_def');
                options.eq($(this).prevAll().length).prop('selected', 'selected');
                select.trigger('change');
                selClose();
            });

            if (l + bodyWidth > w) {
                body.css({
                    left: 'auto',
                    right: 0
                });
            } else {
                body.css({
                    left: 0,
                    right: 'auto'
                });
            }

            head.click(function () {
                arr = $('.button__arrow', this);

                if (!theParent.hasClass('js-select_open')) {
                    selClose();
                    btnClose();
                    theParent.addClass('js-select_open');
                    arr.addClass('button__arrow_state_open');
                } else {
                    theParent.removeClass('js-select_open');
                    arr.removeClass('button__arrow_state_open');
                }

            });
        });
    };
    app.jsSelectInit('.js-select');

	function selClose() {
		$('.js-select').removeClass('js-select_open');
		$('.js-select .button__arrow').removeClass('button__arrow_state_open');
	}

	$(document).click(function(e) {
		if (!$(e.target).closest('.js-select').length) {
			selClose();
		}
	});

	// popup
	$('[data-toggle="pop"]').on('click', function() {
		var target = $(this).attr('data-target');

		function popShow(e) {
			btnClose();

			$('BODY').addClass('body-overlay');
			$('.overlay').fadeIn('fast').css('display', 'block');
			$('#' + e).fadeIn('fast').css('display', 'table');
			$('.pop').not($('#' + e)).fadeOut('fast');
		};

		if (!$('#' + target).is(':visible')) {
			popShow(target);
		} else {
			$('.pop, .overlay').fadeOut('fast');
		}
		return false;
	});

	$('.button_pop_cancel, .pop__close').on('click', function() {
		$('.overlay').trigger('click');
	});

	$('.overlay').click(function(e) {
		if (!$(e.target).closest('.pop__ii').length) {
			$('.pop').fadeOut('fast');
			$('.overlay').fadeOut('fast');
			$('BODY').removeClass('body-overlay');
		}
	});

	$(document).on('keyup', function(e) {
		if (e.keyCode == 27 && $('.pop').is(':visible')) {
			$('.overlay').trigger('click');
		}
	});

}); // dom ready

/* cellPos jQuery plugin */
!function(a){function b(b){var c=[];b.children("tr").each(function(b,d){a(d).children("td, th").each(function(d,e){var i,j,f=a(e),g=0|f.attr("colspan"),h=0|f.attr("rowspan");for(g=g?g:1,h=h?h:1;c[b]&&c[b][d];++d);for(i=d;d+g>i;++i)for(j=b;b+h>j;++j)c[j]||(c[j]=[]),c[j][i]=!0;var k={top:b,left:d};f.data("cellPos",k)})})}a.fn.cellPos=function(a){var c=this.first(),d=c.data("cellPos");if(!d||a){var e=c.closest("table, thead, tbody, tfoot");b(e)}return d=c.data("cellPos")}}(jQuery);
