from __future__ import absolute_import

from rest_framework import serializers

from core import models


class RewardSerializer(serializers.HyperlinkedModelSerializer):
    reporter_login = serializers.CharField(source='reporter.login', read_only=True)
    vulnerability_type = serializers.StringRelatedField()
    product = serializers.StringRelatedField()
    award_bonus = serializers.CharField(source='award_bonus.badge.name_en', read_only=True)
    protocol = serializers.StringRelatedField()

    class Meta:
        model = models.Reward
        fields = (
            'reporter',
            'reporter_login',
            'ticket_code',
            'ticket_number',
            'vulnerability_type',
            'ticket_created',
            'payment_created',
            'department',
            'product',
            'payment_amount_rur',
            'payment_amount_usd',
            'payment_currency',
            'award_bonus',
            'status',
            'points',
            'protocol',
        )


class ReporterSerializer(serializers.ModelSerializer):
    login = serializers.CharField(read_only=True)
    rewards = serializers.HyperlinkedRelatedField(
        many=True, read_only=True,
        view_name='reward-detail',
    )

    class Meta:
        model = models.Reporter
        fields = (
            'uid', 
            'login',
            'rewards',
        )


class VulnerabilitySerializer(serializers.ModelSerializer):

    class Meta:
        model = models.Vulnerability
        fields = '__all__'


class ProductSerializer(serializers.ModelSerializer):
    financial_unit = serializers.StringRelatedField()
    scope = serializers.StringRelatedField()

    class Meta:
        model = models.Product
        fields = '__all__'


class ProtocolSerializer(serializers.ModelSerializer):
    rewards = serializers.HyperlinkedRelatedField(
        many=True, read_only=True,
        view_name='reward-detail',
    )

    class Meta:
        model = models.Protocol
        fields = [
            'created',
            'staff_login',
            'rewards',
        ]
