from __future__ import absolute_import

from django_filters.rest_framework import backends as rest_filter_backends
from rest_framework import mixins, viewsets

from api import filters
from api import serializers
from core import models


class ReadOnlyListModelViewSet(mixins.ListModelMixin,
                               viewsets.GenericViewSet):
    pass


class RewardViewSet(viewsets.ReadOnlyModelViewSet):
    queryset = models.Reward.objects.all()
    serializer_class = serializers.RewardSerializer
    filter_backends = (
        rest_filter_backends.DjangoFilterBackend,
    )
    filter_class = filters.RewardFilterSet


class ReporterViewSet(viewsets.ReadOnlyModelViewSet):
    queryset = models.Reporter.objects.all()
    serializer_class = serializers.ReporterSerializer
    filter_backends = (
        rest_filter_backends.DjangoFilterBackend,
    )
    filter_class = filters.ReporterFilterSet


class VulnerabilityViewSet(ReadOnlyListModelViewSet):
    queryset = models.Vulnerability.objects.all()
    serializer_class = serializers.VulnerabilitySerializer


class ProductViewSet(ReadOnlyListModelViewSet):
    queryset = models.Product.objects.all()
    serializer_class = serializers.ProductSerializer


class ProtocolViewSet(ReadOnlyListModelViewSet):
    queryset = models.Protocol.objects.all()
    serializer_class = serializers.ProtocolSerializer
