# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.apps import AppConfig
from django.db.models import signals as django_signals


class BugBountyInternalConfig(AppConfig):
    name = 'app'
    verbose_name = 'BugBounty Internal Application'

    def ready(self):
        # app.signals imports core.models implicitly
        # that's why we load it when app is ready.
        import app.signals as signals

        django_signals.pre_save.connect(
            signals.reward_pre_save_handler,
            sender='core.Reward', dispatch_uid='reward-pre-save-handler')
        django_signals.post_save.connect(
            signals.reward_post_save_handler,
            sender='core.Reward', dispatch_uid='reward-post-save-handler')
