# -*- coding: utf-8 -*-
from __future__ import unicode_literals


class Winner (object):
    def __init__(self, **kwargs):
        __mdm_id = ''
        for attribute in ('wid', 'name', 'reward', 'reward_amount', 'reward_currency',  'is_foreigner',
                          'country', 'contract', 'hall_name', 'lname'):
            setattr(self, attribute, kwargs.get(attribute))
   
    def _get_mdm_id(self):
        return self.__mdm_id

    def _set_mdm_id(self, mdm_info):
        # URL
        if 'st.' in mdm_info:
            tmp = mdm_info.strip('/ ')
            self.__mdm_id = tmp.split('/')[-1]
        else:
            self.__mdm_id = mdm_info
    
    mdm_id = property(_get_mdm_id, _set_mdm_id)

    def __str__(self):
        result = ''
        result += 'WID: ' + str(self.wid)
        result += ' name: ' + str(self.name)
        return result

    @property
    def condensed_name(self):
        return self.name.replace('\n', ' ')

    def ordering(self):
        """Return tuple for sorting."""
        return (self.reward_currency, self.name)
