from django import forms
from django.core.urlresolvers import reverse

import core.models as models

from core.triggers import registry


__all__ = ['BadgeForm', 'UserBadgeForm']


class BadgeForm(forms.ModelForm):

    image = forms.ImageField(required=False)
    trigger = forms.ChoiceField(registry.registered())

    class Meta:
        model = models.Badge
        fields = [
            'name', 'name_en',
            'is_automatic', 'trigger', 'check_interval',
        ]

    def get_action_url(self):
        if self.instance is not None and self.instance.id is not None:
            return reverse('badge', args=(self.instance.id, ))
        return reverse('badge')


class UserBadgeForm(forms.ModelForm):

    class Meta:
        model = models.UserBadge
        fields = ['user', 'badge']
