# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db.models import F
from django import forms
from core.models import MailTemplate


__all__ = ['MailTemplateForm', 'MailTemplateEditForm']


class MailTemplateForm(forms.ModelForm):
    code = forms.ChoiceField(
        choices=MailTemplate.objects.annotate(name=F('code')).values_list('code', 'name').distinct())

    class Meta:
        model = MailTemplate
        exclude = []


class MailTemplateEditForm(MailTemplateForm):

    class Meta:
        model = MailTemplate
        exclude = ['language']
