from django import forms

from core import models
from core.models import StaticPage

__all__ = ['StaticPageForm', 'EditablePageForm']


class EditablePageForm(forms.ModelForm):
    status = forms.ChoiceField(choices=models.PageTranslation.STATUSES)
    title_ru = forms.CharField(max_length=models.PageTranslation.TITLE_MAXLEN)
    text_ru = forms.CharField()

    class Meta:
        model = models.EditablePage
        exclude = []


class StaticPageForm(forms.ModelForm):
    class Meta:
        model = StaticPage
        fields = ['page_type', 'name', 'status', 'text', 'language']
