# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django import forms

from core import models

__all__ = ['ProductForm']


class ScopeChoiceField(forms.ModelChoiceField):

    def label_from_instance(self, obj):
        return obj.title


class ProductForm(forms.ModelForm):
    scope = ScopeChoiceField(
        queryset=models.ProductScope.objects.all().order_by('id'), required=False)

    class Meta:
        model = models.Product
        fields = '__all__'
