# -*- coding: utf-8 -*-

from app.tasks import create_kaznaops_ticket, create_document_ticket
from django.core.management import base as management
from core.models import Protocol


class Command(management.BaseCommand):

    def add_arguments(self, parser):
        super(Command, self).add_arguments(parser)
        parser.add_argument(
            '--queue', action='store', dest='queue', required=False, choices=['kaznaoperations', 'document']
        )

    def handle(self, *args, **kwargs):
        queue = kwargs.get('queue')
        if queue is None or queue == 'kaznaoperations':
            pending_protocols = Protocol.objects.filter(ticket_kaznaops='')
            for protocol_id in pending_protocols.values_list('pk', flat=True):
                create_kaznaops_ticket.apply_async(args=(protocol_id,))

        if queue is None or queue == 'document':
            pending_protocols = Protocol.objects.filter(ticket_document='')
            for protocol_id in pending_protocols.values_list('pk', flat=True):
                create_document_ticket.apply_async(args=(protocol_id,))
