# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import collections
import datetime
import getpass
import urllib
import urlparse

import requests

from django.conf import settings
from django.core.management import base as management
from django.core.urlresolvers import reverse


Vulnerability = collections.namedtuple('Vulnerability', 'id points name')


class Command(management.BaseCommand):
    help = 'Create TEST Reward ticket through API.'
    
    def add_arguments(self, parser):
        parser.add_argument('--domain', help='API server domain name')
        parser.add_argument('--token', help='API auth token')
        parser.add_argument('--uid', help='Reporter uid')
        parser.add_argument('--staff', help='Staff login', default=getpass.getuser())
        parser.add_argument('--dept', help='Product name')

    def handle(self, *args, **options):
        domain = options['domain']
        url = self.get_url_from_view(domain, 'reward:api')
        vulnerability = self.get_vulnerability(domain)
        response = requests.post(url, {
            'auth_token': self.get_auth_token(options['token']),
            'user_uid': options['uid'],
            'staff_login': options['staff'],
            'staff_uid': 1120000000010073,  # TODO(remedy) This is my UID
            'ticket_code': 123,
            'points': vulnerability.points,
            'payment_amount_usd': vulnerability.points,
            'payment_amount_rur': vulnerability.points*30,
            'department': self.get_department_by_name(domain, options['dept']),
            'ticket_created': datetime.datetime.today().strftime('%Y-%m-%d %T'),
            'vulnerability_type': vulnerability.id,
        })
        self.stdout.write(str(response.content))

    def get_vulnerability(self, domain):
        response = requests.get(self.get_url_from_view(domain, 'vulnerability:list', json=True))
        vulnerability = Vulnerability(**response.json()['vulnerabilities'].pop())
        return vulnerability

    def get_auth_token(self, token=None):
        if token is None:
            return settings.API_AUTH_TOKEN
        else:
            return token

    def get_department_by_name(self, domain, name=None):
        response = requests.get(self.get_url_from_view(domain, 'reward:departments'))
        departments = response.json()
        if name is None:
            department = departments.pop()['id']
        else:
            department = self.find_department_by_name(departments, name)
        return department

    def find_department_by_name(self, departments, name):
        unicode_name = name.decode('utf-8')
        for department in departments:
            if department['name'] == unicode_name:
                return department['id']
        raise ValueError('Department not found: %s' % name)

    def get_url_from_view(self, domain, view_name, **kwargs):
        query = urllib.urlencode(kwargs)
        return urlparse.urlunsplit(
            ('https', domain, reverse(view_name), query, ''))
