# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.core.management import base as management

from core import models


class Command(management.BaseCommand):
    help = "Print CSV report with foreigners' names transliterated."

    def handle(self, *args, **options):
        fieldnames = ['mdm_ticket', 'account_holder', 'account_holder_cyrillic']
        self.stdout.write(';'.join(fieldnames))
        foreigners = models.PaymentInfo.objects.filter(
            is_russian_resident=False, is_actual=True)
        for foreigner in foreigners:
            fields = get_fields(foreigner, fieldnames)
            self.stdout.write(';'.join(fields))


def get_fields(foreigner, fieldnames):
    for fieldname in fieldnames:
        if fieldname == 'account_holder_cyrillic':
            yield foreigner.account_holder_cyrillic.split('\n')[0]
        else:
            yield getattr(foreigner, fieldname)
