# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.conf import settings

from app.tasks import badge as badge_tasks
from core import models


def reward_pre_save_handler(sender, instance, **kwargs):
    # TODO(remedy) Find Badge by invariable id
    badges = models.Badge.objects.filter(
        name_en=settings.YANDEX_SPONSORED_BADGE_NAME)
    if badges.all():
        badge_tasks.deprive_overdue_yandex_sponsored_awards.delay(
            badges.first().id)


def reward_post_save_handler(sender, instance, **kwargs):
    badge_tasks.assign_automatic_badges.delay()
