# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import logging

from celery import task

from core import models


__all__ = ['create_balance_data']

logger = logging.getLogger(__name__)


@task
def create_balance_data():
    new_rewards = models.Reward.objects.filter(status=models.Reward.ST_NEW)
    for reward in new_rewards:
        try:
            reward.create_balance_data()
        except Exception:
            logger.exception('Could not create Balance contract for reward={}'.format(reward.pk))
