# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django import template


register = template.Library()


@register.simple_tag(takes_context=True)
def css_sort_class_select(context, column, up, down):
    query = context['request'].GET.dict()
    if 'sort' in query and query['sort'] == column:
        if 'reverse' in query and query['reverse']:
            return down
        else:
            return up
    else:
        return ''
