from app.views import MainView, RewardView, Ping
from app.urls import product as product_urls
from .badge import urlpatterns as badge_urls
from .hall_of_fame import urlpatterns as hof_urls
from .mail_template import urlpatterns as mail_urls
from .page import urlpatterns as page_urls
from .protocol import urlpatterns as protocol_urls
from .reward import urlpatterns as reward_urls
from .user_profile import urlpatterns as user_profile_urls
from .vulnerability import urlpatterns as vulnerability_urls

from django.conf.urls import include, url


urlpatterns = [
    url(r'^$', MainView.as_view(), name='main'),
    url(r'^badge/', include(badge_urls)),
    url(r'^vulnerability/', include(vulnerability_urls, namespace='vulnerability')),
    url(r'^page/', include(page_urls, namespace='page')),
    url(r'^mail/', include(mail_urls, namespace='mail_template')),
    url(r'^hall-of-fame/', include(hof_urls, namespace='hall_of_fame')),
    url(r'^protocol/', include(protocol_urls, namespace='protocol')),
    url(r'^reward/', include(reward_urls, namespace='reward')),
    url(r'^reward-(?P<reward_id>\d+)/', RewardView.as_view(), name='reward-edit'),
    url(r'^product/', include(product_urls, namespace='product')),
    url(r'^user-profile/', include(user_profile_urls, namespace='user_profile')),
    url(r'^ping/', Ping.as_view(), name='ping'),
]
