from datetime import date

from django.conf.urls import patterns, include, url

from app.views import HallOfFameList
from app.views import AddHallOfFameMember
from app.views import PublishHallOfFame
from app.views import EditHallOfFame


YEAR_MONTH_RE = r'^(?P<year>[0-9]{4})/(?P<month>[0-9]{1,2})/%s'


urlpatterns = patterns('',
    url(r'^$', HallOfFameList.as_view(), name='list',
        kwargs={'year': date.today().year, 'month': date.today().month}),
    url(YEAR_MONTH_RE % r'$', HallOfFameList.as_view(), name='month-list'),
    url(YEAR_MONTH_RE % r'add-member/$', AddHallOfFameMember.as_view(), name='add-member'),
    url(YEAR_MONTH_RE % r'publish/$', PublishHallOfFame.as_view(), name='publish'),
    url(YEAR_MONTH_RE % r'edit/$', EditHallOfFame.as_view(), name='edit'),
)
