from django.conf.urls import url
from app.views import page as page_views


urlpatterns = [
    url(r'^$', page_views.ListPageView.as_view(), name='list'),
    url(r'^create/$', page_views.CreatePageView.as_view(), name='create'),
    url(r'^(?P<slug>[-\w]+)/draft/$',
        page_views.DraftUpdateView.as_view(), name='update-draft'),
    url(r'^(?P<slug>[-\w]+)/uploaded/$',
        page_views.UploadedUpdateView.as_view(), name='update-uploaded'),
    url(r'^(?P<slug>[-\w]+)/downloaded/$',
        page_views.DownloadedUpdateView.as_view(), name='update-downloaded'),
    url(r'^(?P<slug>[-\w]+)/published/$',
        page_views.PublishedUpdateView.as_view(), name='update-published'),
    url(r'^(?P<slug>[-\w]+)/(?P<status>\w+)/(?P<language>\w+)/preview/$',
        page_views.PreviewPageView.as_view(), name='preview'),
    url(r'^delete/(?P<slug>.+)/$',
        page_views.DeletePageView.as_view(), name='delete'),
]
