# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.conf.urls import patterns, url

from app import views


urlpatterns = patterns('',
    url(r'^$', views.RewardList.as_view(), name='list'),
    url(r'^browser/$', views.BrowserRewardList.as_view(), name='browser-list'),
    url(r'^add/$', views.CreateReward.as_view(), name='add'),
    url(r'^(?P<reward_id>\d+)/view/$', views.RewardView.as_view(), name='view'),
    url(r'^api/$', views.RewardAPI.as_view(), name='api'),
    url(r'^api/(?P<reward_id>\d+)/$', views.RewardAPI.as_view(), name='api'),
    url(r'^departments/$', views.DepartmentList.as_view(), name='departments'),
    url(r'^currency/$', views.CurrencyList.as_view(), name='currency'),
)
