from django.conf.urls import patterns, include, url

from app.views import user_profile as views
from app.views import reward as reward_views

urlpatterns = patterns('',
    url(r'^$', views.UserProfileList.as_view(), name='list'),
    url(r'^edit/(?P<pk>\d+)/$',
        views.EditUserProfile.as_view(), name='edit'),
    url(r'^by-uid/(?P<uid>\d+)/$',
        views.UserProfileByUid.as_view(), name='profile-by-uid'),
    url(r'^edit-payment/(?P<pk>\d+)/$',
        views.EditUserPaymentInfo.as_view(), name='edit_payment'),
    url(r'^download-id-document/(?P<pk>\d+)/$',
        views.DownloadUserDocument.as_view(), name='download_id_document'),
    url(r'^edit-badges/add/(?P<pk>\d+)/$',
        views.AddUserBadge.as_view(), name='add_badge'),
    url(r'^edit-badges/delete/(?P<pk>\d+)/$',
        views.DeleteUserBadge.as_view(), name='delete_badge'),
    url(r'^rewards/(?P<pk>\d+)/$',
        reward_views.UserRewardList.as_view(), name='filter_rewards')
)
