# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import xlrd


class BaseReportParser(object):
    CONTRACT_COL_ID = None
    PAYMENT_AMOUNT_COL_ID = None
    CURRENCY_COL_ID = None
    LAST_NAME_COL_ID = None
    CURRENCY_IDS = {
        'RUR': u'RUB',
    }

    def preprocess_column(self, column):
        for value in column:
            yield unicode(value).strip()

    def preprocess_currencies(self, column):
        for value in column:
            yield self.CURRENCY_IDS.get(value, value)

    def preprocess_amounts(self, column):
        for value in column:
            try:
                value = float(value)
            except ValueError:
                value = 0
            yield '%.2f' % value

    def get_records(self, report_content):
        book = xlrd.open_workbook(file_contents=report_content)
        sheet = book.sheet_by_index(0)
        lnames = self.preprocess_column(sheet.col_values(self.LAST_NAME_COL_ID)[1:])
        contracts = self.preprocess_column(sheet.col_values(self.CONTRACT_COL_ID)[1:])
        amounts = self.preprocess_amounts(sheet.col_values(self.PAYMENT_AMOUNT_COL_ID)[1:])
        currencies = self.preprocess_currencies(sheet.col_values(self.CURRENCY_COL_ID)[1:])

        records = list(zip(contracts, lnames, amounts, currencies))
        # Строки с пропусками удаляем
        records = filter(lambda x: all(x), records)
        return records


class ExternalReportParser(BaseReportParser):
    CONTRACT_COL_ID = 3
    PAYMENT_AMOUNT_COL_ID = 18
    CURRENCY_COL_ID = 24
    LAST_NAME_COL_ID = 5


class InternalReportParser(BaseReportParser):
    CONTRACT_COL_ID = 4
    PAYMENT_AMOUNT_COL_ID = 1
    CURRENCY_COL_ID = 2
    LAST_NAME_COL_ID = 0


def audit_protocol_rewards(protocol, financial_report_content):
    our_data = InternalReportParser().get_records(protocol.financial_report_file)
    external_data = ExternalReportParser().get_records(financial_report_content)
    missing = set(our_data) - set(external_data)
    extra = set(external_data) - set(our_data)
    return missing, extra
