# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.core.exceptions import PermissionDenied
from django.utils.decorators import method_decorator
from django_yauth.decorators import yalogin_required


class GroupRequiredMixin(object):
    group_required = None

    def membership_granted(self):
        if self.request.user.is_superuser:
            return True
        else:
            user_groups = self.request.user.groups.values_list('name', flat=True)
            return self.group_required in user_groups

    @method_decorator(yalogin_required)
    def dispatch(self, request, *args, **kwargs):
        if not self.membership_granted():
            raise PermissionDenied
        return super(GroupRequiredMixin, self).dispatch(request, *args, **kwargs)


class SuperuserRequiredMixin(object):

    @method_decorator(yalogin_required)
    def dispatch(self, request, *args, **kwargs):
        if not request.user.is_superuser:
            raise PermissionDenied
        return super(SuperuserRequiredMixin, self).dispatch(request, *args, **kwargs)
