#!/usr/bin/env python
import os
import sys


def _setup_environ():
    os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'internal.settings')

    from django.conf import settings


def django_main():
    _setup_environ()

    from django.core.management import execute_from_command_line

    execute_from_command_line(sys.argv)


def celery_main():
    _setup_environ()

    from celery.__main__ import main

    return main()


if __name__ == "__main__":
    os.environ.setdefault("DJANGO_SETTINGS_MODULE", "internal.settings")

    from django.core.management import execute_from_command_line

    execute_from_command_line(sys.argv)
