# coding: utf-8

from cab.api import views
from cab.utils.urls import url
from cab.widgets import registry


urlpatterns = [
    url('^widgets/$', views.WidgetList, name='widgets'),
    url('^stock-options/$', views.stock_options, name='stock_options'),
    url('^stock-options/(?P<login>[\w\-\_\.]+)/?$', views.stock_options, name='stock_options'),
    url('^push-plan-insider/?$', views.push_plan_insider, name='push_plan_insider'),
    url('^get-plan-insider/?$', views.get_plan_insider, name='get_plan_insider'),
]


for widget in registry.values():
    urlpatterns.extend(widget.get_urlpatterns())
