# coding: utf-8

from __future__ import unicode_literals

from django.db import DatabaseError

from cab.core.models import UserData
from cab.utils import helpers, dicts


def get_default_user_tpl():
    return {
        'persons_fields': [],
        'persons_filter_id': None,
    }


@helpers.fail_silently(cls=DatabaseError)
def get_user_data_obj(uid):
    return UserData.objects.filter(uid=uid).first()


@helpers.fail_silently(cls=DatabaseError)
def get_user_data(uid):
    """
    Гарантируем наличие всех ключей в возвращаемом объекте.
    """
    data_dict = get_default_user_tpl()
    user_data_obj = get_user_data_obj(uid)
    if user_data_obj:
        dicts.update_existing_keys(data_dict, user_data_obj.data)
    return data_dict


@helpers.fail_silently(cls=DatabaseError)
def update_user_data(uid, **kwargs):
    """
    Гарантируем наличие всех ключей в сохраняемом объекте.
    """
    user_data_obj = get_user_data_obj(uid)
    data_dict = get_default_user_tpl()

    if user_data_obj is not None:
        dicts.update_existing_keys(data_dict, user_data_obj.data)
        dicts.update_existing_keys(data_dict, kwargs)
        user_data_obj.data = data_dict
    else:
        dicts.update_existing_keys(data_dict, kwargs)
        user_data_obj = UserData(uid=uid, data=data_dict)
    return user_data_obj.save()
