# coding: utf-8

from __future__ import unicode_literals

from django.views.generic import View
from django.http import HttpResponse, JsonResponse


def build_error_response(data, status=400):
    return JsonResponse(
        data={'errors': data},
        safe=False,
        status=status,
    )


class BaseView(View):

    def dispatch(self, request, *args, **kwargs):
        """
        Convert response dicts into json.
        """
        response = super(BaseView, self).dispatch(request, *args, **kwargs)
        if not isinstance(response, HttpResponse):
            response = JsonResponse(response, safe=False)
        return response

    error = staticmethod(build_error_response)
