# coding: utf-8
from __future__ import unicode_literals


class BaseWidget(object):

    id = None

    endpoints = {}

    @classmethod
    def get_handler(cls, endpoint_name, request):
        endpoint = cls.endpoints.get(endpoint_name)
        handler = endpoint and endpoint['handler']
        if isinstance(handler, dict):
            handler = handler.get(request.method)
        return handler and handler(auth=request.auth)

    @classmethod
    def get_urlpatterns(cls):
        from cab.utils.urls import url
        from cab.api import views

        prefix = r'^widgets/(?P<widget_id>{widget_id}){endpoint_re}'
        return [
            url(
                regex=prefix.format(
                    widget_id=cls.id,
                    endpoint_re=meta['regex'],
                ),
                view=views.WidgetDetail,
                kwargs={
                    'endpoint': name,
                },
            )
            for name, meta in cls.endpoints.items()
        ]


class BaseEndpointHandler(object):

    validator_cls = None

    def __init__(self, auth):
        self.auth = auth

    def handle(self, data):
        return {}
